<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\DependencyInjection\RestRouteAttributes;

class RestRouteRegistry
{

    /**
     * @var array<string, array{
     *     baseRoute: string,
     *     override: bool,
     *     public: bool,
     *     namespace: string,
     *     permission: string,
     *     routes: array{
     *          route: string,
     *          callable: callable,
     *          methods: array|string,
     *          permission: string|null,
     *          arguments: array,
     *          override: bool,
     *          public: bool,
     *          namespace: string
     *    }
     * }>
     */
    private array $routes = [];

    public function __construct()
    {
    }

    /**
     * @return array<string, array{
     *     baseRoute: string,
     *     override: bool,
     *     public: bool,
     *     namespace: string,
     *     permission: string,
     *     routes: array{
     *          route: string,
     *          callable: callable,
     *          methods: array|string,
     *          permission: string|null,
     *          arguments: array,
     *          override: bool,
     *          public: bool,
     *          namespace: string
     *    }
     * }>
     */
    public function getRoutes(): array
    {
        return $this->routes;
    }

    public function addScope(
        string $name,
        string $route,
        bool   $override,
        bool   $public,
        string $namespace,
        ?string $permission
    )
    {
        $this->routes[$name] = [
            'baseRoute' => $route,
            'override' => $override,
            'public' => $public,
            'namespace' => $namespace,
            'permission' => $permission,
        ];
    }

    public function addRoute(
        callable     $callable,
        string       $scope,
        string       $route,
        array|string $methods,
        ?string      $permission,
        array        $arguments,
        bool         $override,
        bool         $public,
        ?string      $namespace)
    {
        $this->routes[$scope]['routes'][] = [
            'route' => $route,
            'callable' => $callable,
            'methods' => $methods,
            'permission' => $permission,
            'arguments' => $arguments,
            'override' => $override,
            'public' => $public,
            'namespace' => $namespace
        ];
    }

}