<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\DependencyInjection\Initializer;

use WRCE\Dependencies\Symfony\Component\DependencyInjection\ContainerBuilder;
use WRCE\Dependencies\Symfony\Component\DependencyInjection\Definition;
use WRCE\Dependencies\Symfony\Component\DependencyInjection\Extension\Extension;
use WRCE\Dependencies\Symfony\Component\DependencyInjection\Reference;
use WRCE\Dependencies\WordpressModels\DependencyInjection\Initializer\Attributes\ForceInitialize;

class InitializerExtension extends Extension
{


    public function load(array $configs, ContainerBuilder $container)
    {
        $container->registerAttributeForAutoconfiguration(ForceInitialize::class, self::tagForceInitialize(...));

        // register the service initializer
        $container->register(ServiceInitializer::class)
            ->addArgument(new Reference('service_container'))
            ->setPublic(true)
            ->setAutowired(true)
            ->setAutoconfigured(true);
    }

    public static function tagForceInitialize(Definition $definition): void
    {
        // prevent auto-removal due to the service being private
        $definition->setPublic(true);
        // set non-lazy
        $definition->setLazy(false);

        // tag the service
        $definition->addTag('force_initialize');
    }

}