<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels;

/**
 *
 */
class Classes
{

    /**
     * Check whether the given `$class` uses `$trait`.
     *
     * @param object|class-string|null $class
     * @param trait-string|null $trait
     * @return bool true    if the `$class` uses the given `$trait`,
     *              false   if any of `$class` or `$trait` is falsy, or the `$class` does not use the `$trait`
     */
    public static function classUsesTrait(object|string|null $class, ?string $trait): bool
    {
        if (!$trait) {
            return false;
        }

        while ($class) {
            if (in_array($trait, class_uses($class))) {
                return true;
            }
            $class = get_parent_class($class);
        }

        return false;
    }

}
