<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM;

use WRCE\Dependencies\Doctrine\ORM\Exception\ORMException;

/**
 * Is thrown when a transaction is required for the current operation, but there is none open.
 *
 * @link        www.doctrine-project.com
 */
class TransactionRequiredException extends ORMException
{
    /** @return TransactionRequiredException */
    public static function transactionRequired()
    {
        return new self('An open transaction is required for this operation.');
    }
}
