<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Tools\Exception;

use WRCE\Dependencies\Doctrine\ORM\Exception\ORMException;
use WRCE\Dependencies\Doctrine\ORM\Exception\SchemaToolException;

final class NotSupported extends ORMException implements SchemaToolException
{
    public static function create(): self
    {
        return new self('This behaviour is (currently) not supported by Doctrine 2');
    }
}
