<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Query\Filter;

use WRCE\Dependencies\Doctrine\ORM\Exception\ORMException;

use function sprintf;

class FilterException extends ORMException
{
    public static function cannotConvertListParameterIntoSingleValue(string $name): self
    {
        return new self(sprintf('Cannot convert list-based SQL filter parameter "%s" into a single value.', $name));
    }

    public static function cannotConvertSingleParameterIntoListValue(string $name): self
    {
        return new self(sprintf('Cannot convert single SQL filter parameter "%s" into a list value.', $name));
    }
}
