<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Query\AST;

/**
 * JoinAssociationDeclaration ::= JoinAssociationPathExpression ["AS"] AliasIdentificationVariable
 *
 * @link    www.doctrine-project.org
 */
class JoinAssociationDeclaration extends Node
{
    /** @var JoinAssociationPathExpression */
    public $joinAssociationPathExpression;

    /** @var string */
    public $aliasIdentificationVariable;

    /** @var IndexBy|null */
    public $indexBy;

    /**
     * @param JoinAssociationPathExpression $joinAssociationPathExpression
     * @param string                        $aliasIdentificationVariable
     * @param IndexBy|null                  $indexBy
     */
    public function __construct($joinAssociationPathExpression, $aliasIdentificationVariable, $indexBy)
    {
        $this->joinAssociationPathExpression = $joinAssociationPathExpression;
        $this->aliasIdentificationVariable   = $aliasIdentificationVariable;
        $this->indexBy                       = $indexBy;
    }

    /**
     * {@inheritDoc}
     */
    public function dispatch($sqlWalker)
    {
        return $sqlWalker->walkJoinAssociationDeclaration($this);
    }
}
