<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Mapping;

use BackedEnum;
use ReflectionProperty;

interface TypedFieldMapper
{
    /**
     * Validates & completes the given field mapping based on typed property.
     *
     * @param array{fieldName: string, enumType?: class-string<BackedEnum>, type?: string} $mapping The field mapping to validate & complete.
     *
     * @return array{fieldName: string, enumType?: class-string<BackedEnum>, type?: string} The updated mapping.
     */
    public function validateAndComplete(array $mapping, ReflectionProperty $field): array;
}
