<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Mapping;

use ReflectionProperty;

final class ChainTypedFieldMapper implements TypedFieldMapper
{
    /**
     * @readonly
     * @var TypedFieldMapper[] $typedFieldMappers
     */
    private array $typedFieldMappers;

    public function __construct(TypedFieldMapper ...$typedFieldMappers)
    {
        $this->typedFieldMappers = $typedFieldMappers;
    }

    /**
     * {@inheritDoc}
     */
    public function validateAndComplete(array $mapping, ReflectionProperty $field): array
    {
        foreach ($this->typedFieldMappers as $typedFieldMapper) {
            $mapping = $typedFieldMapper->validateAndComplete($mapping, $field);
        }

        return $mapping;
    }
}
