<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Exception;

use function sprintf;

final class InvalidHydrationMode extends ORMException implements ManagerException
{
    public static function fromMode(string $mode): self
    {
        return new self(sprintf('"%s" is an invalid hydration mode.', $mode));
    }
}
