<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Cache\Exception;

use WRCE\Dependencies\Doctrine\Common\Cache\Cache;

use function get_debug_type;

final class MetadataCacheUsesNonPersistentCache extends CacheException
{
    public static function fromDriver(Cache $cache): self
    {
        return new self(
            'Metadata Cache uses a non-persistent cache driver, ' . get_debug_type($cache) . '.'
        );
    }
}
