<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\DependencyInjection\Compiler;

use WRCE\Dependencies\Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use WRCE\Dependencies\Symfony\Component\DependencyInjection\ContainerBuilder;
use WRCE\Dependencies\Symfony\Component\HttpFoundation\Session\Storage\Handler\PdoSessionHandler;

use function array_keys;
use function method_exists;

/**
 * Blacklist tables used by well-known Symfony classes.
 *
 * @deprecated Implement your own include/exclude mechanism
 *
 * @final since 2.9
 */
class WellKnownSchemaFilterPass implements CompilerPassInterface
{
    /** @return void */
    public function process(ContainerBuilder $container)
    {
        $blacklist = [];

        foreach ($container->getDefinitions() as $definition) {
            if ($definition->isAbstract() || $definition->isSynthetic()) {
                continue;
            }

            if ($definition->getClass() !== PdoSessionHandler::class) {
                continue;
            }

            $table = $definition->getArguments()[1]['db_table'] ?? 'sessions';

            if (! method_exists($definition->getClass(), 'configureSchema')) {
                $blacklist[] = $table;
            }

            break;
        }

        if (! $blacklist) {
            return;
        }

        $definition = $container->getDefinition('doctrine.dbal.well_known_schema_asset_filter');
        $definition->replaceArgument(0, $blacklist);

        foreach (array_keys($container->getParameter('doctrine.connections')) as $name) {
            $definition->addTag('doctrine.dbal.schema_filter', ['connection' => $name]);
        }
    }
}
