<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\Dbal;

use WRCE\Dependencies\Doctrine\DBAL\Connection;
use WRCE\Dependencies\Doctrine\DBAL\Tools\Console\ConnectionProvider;
use WRCE\Dependencies\Doctrine\Persistence\AbstractManagerRegistry;

class ManagerRegistryAwareConnectionProvider implements ConnectionProvider
{
    private AbstractManagerRegistry $managerRegistry;

    public function __construct(AbstractManagerRegistry $managerRegistry)
    {
        $this->managerRegistry = $managerRegistry;
    }

    public function getDefaultConnection(): Connection
    {
        return $this->managerRegistry->getConnection();
    }

    public function getConnection(string $name): Connection
    {
        return $this->managerRegistry->getConnection($name);
    }
}
