<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\Dbal;

use WRCE\Dependencies\Doctrine\DBAL\Schema\AbstractAsset;

use function in_array;

/** @deprecated Implement your own include/exclude mechanism */
class BlacklistSchemaAssetFilter
{
    /** @var string[] */
    private array $blacklist;

    /** @param string[] $blacklist */
    public function __construct(array $blacklist)
    {
        $this->blacklist = $blacklist;
    }

    /** @param string|AbstractAsset $assetName */
    public function __invoke($assetName): bool
    {
        if ($assetName instanceof AbstractAsset) {
            $assetName = $assetName->getName();
        }

        return ! in_array($assetName, $this->blacklist, true);
    }
}
