<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\Command\Proxy;

use WRCE\Dependencies\Doctrine\ORM\Tools\Console\EntityManagerProvider;
use WRCE\Dependencies\Symfony\Component\Console\Input\InputInterface;
use WRCE\Dependencies\Symfony\Component\Console\Output\OutputInterface;

use function trigger_deprecation;

/**
 * @internal
 * @deprecated
 */
trait OrmProxyCommand
{
    private ?EntityManagerProvider $entityManagerProvider;

    public function __construct(?EntityManagerProvider $entityManagerProvider = null)
    {
        parent::__construct($entityManagerProvider);

        $this->entityManagerProvider = $entityManagerProvider;

        trigger_deprecation(
            'doctrine/doctrine-bundle',
            '2.8',
            'Class "%s" is deprecated. Use "%s" instead.',
            self::class,
            parent::class,
        );
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        if (! $this->entityManagerProvider) {
            DoctrineCommandHelper::setApplicationEntityManager($this->getApplication(), $input->getOption('em'));
        }

        return parent::execute($input, $output);
    }
}
