<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\DBAL\Logging;

use WRCE\Dependencies\Doctrine\DBAL\Driver as DriverInterface;
use WRCE\Dependencies\Doctrine\DBAL\Driver\Middleware as MiddlewareInterface;
use WRCE\Dependencies\Psr\Log\LoggerInterface;

final class Middleware implements MiddlewareInterface
{
    private LoggerInterface $logger;

    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    public function wrap(DriverInterface $driver): DriverInterface
    {
        return new Driver($driver, $this->logger);
    }
}
