<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\DBAL\Exception;

use WRCE\Dependencies\Doctrine\DBAL\Exception;

use function sprintf;

/**
 * @internal
 *
 * @psalm-immutable
 */
final class NoKeyValue extends Exception
{
    public static function fromColumnCount(int $columnCount): self
    {
        return new self(
            sprintf(
                'Fetching as key-value pairs requires the result to contain at least 2 columns, %d given.',
                $columnCount,
            ),
        );
    }
}
