<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\DBAL\ArrayParameters\Exception;

use WRCE\Dependencies\Doctrine\DBAL\ArrayParameters\Exception;
use LogicException;

use function sprintf;

/** @psalm-immutable */
class MissingNamedParameter extends LogicException implements Exception
{
    public static function new(string $name): self
    {
        return new self(
            sprintf('Named parameter "%s" does not have a bound value.', $name),
        );
    }
}
