<?php

namespace RTMCustomMails\EmailSections;

use WRCE\Dependencies\WordpressModels\Traits\SingletonTrait;
use WP_Term;

/**
 *
 */
class ActionSectionRender
{

    use SingletonTrait;

    public const WOOCOMMERCE_DEFAULT_EMAIL_ACTIONS = [
        'woocommerce_email_header' => [
            'email_heading' => '',
            'email' => null,
            'objectType' => 'generic'
        ],
        'woocommerce_email_footer' => [
            'email' => null,
            'objectType' => 'generic'
        ],
        'woocommerce_email_order_details' => [
            'order' => null,
            'sent_to_admin' => false,
            'plain_text' => false,
            'email' => null,
            'objectType' => 'order'
        ],
        'woocommerce_email_order_meta' => [
            'order' => null,
            'sent_to_admin' => false,
            'plain_text' => false,
            'email' => null,
            'objectType' => 'order'
        ],
        'woocommerce_email_customer_details' => [
            'order' => null,
            'sent_to_admin' => false,
            'plain_text' => false,
            'email' => null,
            'objectType' => 'user'
        ]
    ];

    public function __construct()
    {
        add_filter('wrce_email_section_hooks', [$this, 'defaultHooks']);
        add_filter('wrce_email_section_action', [$this, 'setupHookAction'], 5, 2);
        add_filter('wrce_email_section_action', [$this, 'fallbackAction'], 100);
    }

    /**
     * @param $arr
     * @return array
     */
    public function defaultHooks($arr): array
    {
        return array_merge($arr, self::WOOCOMMERCE_DEFAULT_EMAIL_ACTIONS);
    }

    /**
     * Setup action using Woocommerce default actions.
     * @param numeric|array $section array if the section is already evaluated to be a default action.
     * @param array $args any args, where the last element is an array for the timber context
     * @return array{string, array}|WP_Term
     */
    public function setupHookAction($section, $args): WP_Term|array|string
    {
        return $this->setupAction($section, $args, apply_filters('wrce_email_section_hooks', []));
    }

    /**
     * Check whether the section is an action in the defaultActions list
     * @param string|array $section array if the section is already evaluated to be a default action.
     * @param array $args any args, where the last element is an array for the timber context
     * @param array $defaultActions
     * @return array{string, array}
     */
    private function setupAction(mixed $section, array $args, array $defaultActions): array|string
    {
        if (is_array($section)) {
            return $section;
        }
        // $section is string

        if (isset($defaultActions[$section])) {
            $action_default_arguments = $defaultActions[$section];

            // fill action argument array
            $action_args = [];
            foreach ($action_default_arguments as $arg_name => $arg_default_value) {
                $action_args[] = $args[$arg_name] ?? $arg_default_value;
            }

            return [$section, $action_args];
        }

        // not a default action, pass
        return $section;
    }

    /**
     * Default fallback action
     * @param $section
     * @return array
     */
    public function fallbackAction($section): array
    {
        if (is_array($section)) {
            return $section;
        }
        return ['wrce_render_email_section', []];
    }

}