<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Symfony\Bridge\Doctrine\SchemaListener;

use WRCE\Dependencies\Doctrine\Common\EventSubscriber;
use WRCE\Dependencies\Doctrine\ORM\Tools\ToolEvents;
use WRCE\Dependencies\Symfony\Bridge\Doctrine\Security\RememberMe\DoctrineTokenProvider;

trigger_deprecation('symfony/doctrine-bridge', '6.3', 'The "%s" class is deprecated. Use "%s" instead.', RememberMeTokenProviderDoctrineSchemaSubscriber::class, RememberMeTokenProviderDoctrineSchemaListener::class);

/**
 * Automatically adds the rememberme table needed for the {@see DoctrineTokenProvider}.
 *
 * @author Wouter de Jong <wouter@wouterj.nl>
 *
 * @deprecated since Symfony 6.3, use {@link RememberMeTokenProviderDoctrineSchemaListener} instead
 */
final class RememberMeTokenProviderDoctrineSchemaSubscriber extends RememberMeTokenProviderDoctrineSchemaListener implements EventSubscriber
{
    public function getSubscribedEvents(): array
    {
        if (!class_exists(ToolEvents::class)) {
            return [];
        }

        return [
            ToolEvents::postGenerateSchema,
        ];
    }
}
