<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Mapping;

/**
 * References name of a column in the SELECT clause of a SQL query.
 * Scalar result types can be included in the query result by specifying this annotation in the metadata.
 *
 * @Annotation
 * @Target("ANNOTATION")
 */
final class ColumnResult implements MappingAttribute
{
    /**
     * The name of a column in the SELECT clause of a SQL query.
     *
     * @var string
     */
    public $name;
}
