<?php

namespace RTMCustomMails\EmailOptions;

use RTMCustomMails\GeneratorArray;
use WC_Email;

class OrderEmailHasProductEnabledCondition extends AbstractEmailEnabledCondition
{

    /**
     * @inheritDoc
     */
    public function handleEnabledCondition(bool $enabled, mixed $obj, WC_Email $email = null)
    {
        // early exit if not enabled or no email
        if (!$enabled || !$email) {
            return $enabled;
        }

        // get the selected attribute ids
        $productIds = array_map('intval', $email->get_option('order_contains_product', []) ?: []);
        // early exit if no attributes are selected
        if (!$productIds) {
            return true;
        }

        // collect all product attributes from order
        $orderProducts = array_reduce($obj?->get_items() ?? [], function ($carry, $item) {
            $product = $item->get_product();

            if ($product) {
                $carry[] = $product->get_id();
            }

            return $carry;
        }, []);

        // check if any of the selected attributes is in the order
        return $enabled && count(array_intersect($productIds, $orderProducts)) > 0;
    }

    public function addOption(array $formFields)
    {
        $formFields['order_contains_product'] = new GeneratorArray([
            'title' => 'Only for orders containing certain products',
            'description' => 'Only send this email type for orders containing the selected product',
            'type' => 'multiselect',
            'default' => [],
            'options' => function () {
                $products = wc_get_products([
                    'status' => ['private', 'publish'],
                    'limit' => 400, // the frontend tends to not be able to handle more than 400 options
                ]);
                return array_reduce($products, function ($carry, \WC_Product $product) {
                    $carry[$product->get_id()] = $product->get_title();
                    return $carry;
                }, []);
            }
        ]);

        return $formFields;
    }
}