<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\Entity;

use WRCE\Dependencies\Doctrine\ORM\Mapping as ORM;

/**
 * This is sort of legacy, so we won't put any effort in this mapping
 *
 * WpLinks
 */
#[ORM\Table('links')]
#[ORM\Index(['link_visible'], name: 'link_visible')]
#[ORM\Entity]
class Links
{
    #[ORM\Column(name: 'link_id', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?string $linkId = null;

    #[ORM\Column(name: 'link_url', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkUrl = '';

    #[ORM\Column(name: 'link_name', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkName = '';

    #[ORM\Column(name: 'link_image', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkImage = '';

    #[ORM\Column(name: 'link_target', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::STRING, length: 25)]
    private string $linkTarget = '';

    #[ORM\Column(name: 'link_description', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkDescription = '';

    #[ORM\Column(name: 'link_visible', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::STRING, length: 20, options: ['default' => 'Y'])]
    private string $linkVisible = 'Y';

    #[ORM\Column(name: 'link_owner', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::BIGINT, options: ['default' => 1, 'unsigned' => true])]
    private string $linkOwner = '1';

    #[ORM\Column(name: 'link_rating', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::INTEGER)]
    private string $linkRating = '0';

    #[ORM\Column(name: 'link_updated', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::DATETIME_MUTABLE, options: ['default' => '0000-00-00 00:00:00'])]
    private string $linkUpdated = '0000-00-00 00:00:00';

    #[ORM\Column(name: 'link_rel', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkRel = '';

    #[ORM\Column(name: 'link_notes', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::TEXT, length: 16_777_215)]
    private ?string $linkNotes = null;

    #[ORM\Column(name: 'link_rss', type: \WRCE\Dependencies\Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkRss = '';


}
