<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM;

use WRCE\Dependencies\Doctrine\Common\EventSubscriber;
use WRCE\Dependencies\Doctrine\ORM\Event\OnClearEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Event\OnFlushEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Event\PostFlushEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Event\PostLoadEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Event\PostPersistEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Event\PostRemoveEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Event\PostUpdateEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Event\PreFlushEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Event\PrePersistEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Event\PreRemoveEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Event\PreUpdateEventArgs;
use WRCE\Dependencies\Doctrine\ORM\Events;

final class DoctrineEventHookBridge implements EventSubscriber
{

    public function getSubscribedEvents(): array
    {
        return [
            Events::preUpdate,
            Events::preFlush,
            Events::prePersist,
            Events::preRemove,

            Events::postLoad,
            Events::postFlush,
            Events::postPersist,
            Events::postRemove,
            Events::postUpdate,

            Events::onClear,
            Events::onFlush,
        ];
    }

    public function preUpdate(PreUpdateEventArgs $eventArgs): void
    {
        do_action('doctrine_pre_update', $eventArgs);
    }

    public function preFlush(PreFlushEventArgs $eventArgs): void
    {
        do_action('doctrine_pre_flush', $eventArgs);
    }

    public function prePersist(PrePersistEventArgs $eventArgs): void
    {
        do_action('doctrine_pre_persist', $eventArgs);
    }

    public function preRemove(PreRemoveEventArgs $eventArgs): void
    {
        do_action('doctrine_pre_remove', $eventArgs);
    }

    public function postLoad(PostLoadEventArgs $eventArgs): void
    {
        do_action('doctrine_post_load', $eventArgs);
    }

    public function postFlush(PostFlushEventArgs $eventArgs): void
    {
        do_action('doctrine_post_flush', $eventArgs);
    }

    public function postPersist(PostPersistEventArgs $eventArgs): void
    {
        do_action('doctrine_post_persist', $eventArgs);
    }

    public function postRemove(PostRemoveEventArgs $eventArgs): void
    {
        do_action('doctrine_post_remove', $eventArgs);
    }

    public function postUpdate(PostUpdateEventArgs $eventArgs): void
    {
        do_action('doctrine_post_update', $eventArgs);
    }

    public function onClear(OnClearEventArgs $eventArgs): void
    {
        do_action('doctrine_on_clear', $eventArgs);
    }

    public function onFlush(OnFlushEventArgs $eventArgs): void
    {
        do_action('doctrine_on_flush', $eventArgs);
    }

}
