<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */ declare(strict_types=1);

namespace WRCE\Dependencies\Jawira\CaseConverter\Split;

use WRCE\Dependencies\Jawira\CaseConverter\Glue\SpaceGluer;

class SpaceSplitter extends Splitter
{
    /** @internal */
    public const PATTERN = '#' . SpaceGluer::DELIMITER . '+#u';

    /**
     * @return string[]
     * @throws \WRCE\Dependencies\Jawira\CaseConverter\CaseConverterException
     */
    public function split(): array
    {
        return $this->splitUsingPattern($this->inputString, self::PATTERN);
    }
}
