<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Mapping;

use Attribute;
use WRCE\Dependencies\Doctrine\Common\Annotations\Annotation\NamedArgumentConstructor;
use WRCE\Dependencies\Doctrine\ORM\EntityRepository;

/**
 * @Annotation
 * @NamedArgumentConstructor()
 * @Target("CLASS")
 */
#[Attribute(Attribute::TARGET_CLASS)]
final class MappedSuperclass implements MappingAttribute
{
    /**
     * @var string|null
     * @psalm-var class-string<EntityRepository>|null
     * @readonly
     */
    public $repositoryClass;

    /** @psalm-param class-string<EntityRepository>|null $repositoryClass */
    public function __construct(?string $repositoryClass = null)
    {
        $this->repositoryClass = $repositoryClass;
    }
}
