<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\Mapping;

use WRCE\Dependencies\Doctrine\ORM\Mapping\ClassMetadata;

class ClassMetadataCollection
{
    private ?string $path      = null;
    private ?string $namespace = null;

    /** @var ClassMetadata[] */
    private array $metadata;

    /** @param ClassMetadata[] $metadata */
    public function __construct(array $metadata)
    {
        $this->metadata = $metadata;
    }

    /** @return ClassMetadata[] */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /** @param string $path */
    public function setPath($path)
    {
        $this->path = $path;
    }

    /** @return string|null */
    public function getPath()
    {
        return $this->path;
    }

    /** @param string $namespace */
    public function setNamespace($namespace)
    {
        $this->namespace = $namespace;
    }

    /** @return string|null */
    public function getNamespace()
    {
        return $this->namespace;
    }
}
