<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\DBAL\Schema\Exception;

use WRCE\Dependencies\Doctrine\DBAL\Schema\ForeignKeyConstraint;
use WRCE\Dependencies\Doctrine\DBAL\Schema\SchemaException;
use WRCE\Dependencies\Doctrine\DBAL\Schema\Table;

use function implode;
use function sprintf;

/** @psalm-immutable */
final class NamedForeignKeyRequired extends SchemaException
{
    public static function new(Table $localTable, ForeignKeyConstraint $foreignKey): self
    {
        return new self(
            sprintf(
                'The performed schema operation on "%s" requires a named foreign key, ' .
                'but the given foreign key from (%s) onto foreign table "%s" (%s) is currently unnamed.',
                $localTable->getName(),
                implode(', ', $foreignKey->getColumns()),
                $foreignKey->getForeignTableName(),
                implode(', ', $foreignKey->getForeignColumns()),
            ),
        );
    }
}
