<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\DBAL\Driver\Mysqli\Initializer;

use WRCE\Dependencies\Doctrine\DBAL\Driver\Mysqli\Exception\InvalidOption;
use WRCE\Dependencies\Doctrine\DBAL\Driver\Mysqli\Initializer;
use mysqli;

use function mysqli_options;

final class Options implements Initializer
{
    /** @var array<int,mixed> */
    private array $options;

    /** @param array<int,mixed> $options */
    public function __construct(array $options)
    {
        $this->options = $options;
    }

    public function initialize(mysqli $connection): void
    {
        foreach ($this->options as $option => $value) {
            if (! mysqli_options($connection, $option, $value)) {
                throw InvalidOption::fromOption($option, $value);
            }
        }
    }
}
