<?php

namespace RTMCustomMails\ContextBuilder;

use RTMMailComposer\Model\CustomMail;
use WP_User;

class UserContextBuilder extends ObjectTypeContextBuilder
{
    public function __construct()
    {
        parent::__construct('user');
    }

    /**
     * Defines the data available to email templates when handling user-related contexts.
     */
    protected function defineWhitelist(): array
    {
        return [
            'password_reset_link',
            'password_reset_key',
            'user_id',
            'user_login',
            'user_email',
            'user_first_name',
            'user_last_name',
            'user_display_name',
            'user_nicename',
            'user_url',
            'user_registered',
            'user_description',
            'user_avatar',
            'user_roles',
            'user_role',
            'user_meta',
        ];
    }

    /**
     * Prepares the data context specifically for user-related emails.
     */
    protected function buildContext(CustomMail $mail, $mailObject, array $context = []): array
    {
        /** @var WP_User $user */
        $user = $mailObject instanceof WP_User ? $mailObject : new WP_User();

        // Password and user identification context
        $context['password_reset_link'] = $context['password_reset_link'] ?? '';
        $context['password_reset_key'] = $context['password_reset_key'] ?? '';

        // Detailed user context
        $context['user_id'] = $user->ID;
        $context['user_login'] = $user->user_login;
        $context['user_email'] = $user->user_email;
        $context['user_first_name'] = $user->first_name;
        $context['user_last_name'] = $user->last_name;
        $context['user_display_name'] = $user->display_name;
        $context['user_nicename'] = $user->user_nicename;
        $context['user_url'] = $user->user_url;
        $context['user_registered'] = $user->user_registered;
        $context['user_description'] = $user->description;
        $context['user_avatar'] = $user->avatar;
        $context['user_roles'] = $user->roles;
        $context['user_role'] = $user->roles[0] ?? '';
        $context['user_meta'] = $user->meta;

        // Apply a filter to allow other plugins to modify the context
        return apply_filters("wcre_prepare_context_{$this->getSubject()}", $context, $mail, $mailObject);
    }
}
