<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\Migrations;

use WRCE\Dependencies\Doctrine\DBAL\Platforms\MySQL80Platform;
use WRCE\Dependencies\Doctrine\DBAL\Schema\MySQLSchemaManager;
use Doctrine\Migrations\Configuration\Connection\ExistingConnection;
use Doctrine\Migrations\DependencyFactory;
use WRCE\Dependencies\Doctrine\ORM\EntityManagerInterface;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Driver\DatabaseDriver;
use WRCE\Dependencies\WordpressModels\ORM\Command\DatabaseSchemaTool;

class MigrationsTool
{

    public function __construct(private EntityManagerInterface $em)
    {
        $tool = new DatabaseSchemaTool($em, $this->getEnhancedSchemaManager($em));
    }

    /**
     * @return string[]
     * @throws \WRCE\Dependencies\Doctrine\DBAL\Exception
     */
    public function getMigrationLines(): array
    {
        $dependencyFactory = DependencyFactory::fromEntityManager(
            $this->em,
            new DatabaseDriver($schemaManager),
            new ExistingConnection($connection),
        );

        $schemaDumper = $dependencyFactory->getSchemaDumper();
        $nameGenerator = $dependencyFactory->getClassNameGenerator();
        $className = $nameGenerator->generateClassName($metadata);
        $schemaDumper->dump('App\Migrations\Version20211010101010', [], true, 120);
    }

    /**
     * Get an enhanced schema manager that can handle the enum type.
     *
     * @param EntityManagerInterface $entityManager
     * @return DatabaseDriver
     * @throws \WRCE\Dependencies\Doctrine\DBAL\Exception
     */
    private function getEnhancedSchemaManager(EntityManagerInterface $entityManager): MySQLSchemaManager
    {
        $platform = new MySQL80Platform();
        $platform->registerDoctrineTypeMapping('enum', 'string');

        return new MySQLSchemaManager($entityManager->getConnection(), $platform);
    }



}