<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\DependencyInjection\Metabox;

use WP_Post;

interface MetaboxInterface
{

    const CONTEXTS = ['normal', 'side', 'advanced'];
    const PRIORITIES = ['high', 'core', 'default', 'low'];

    /**
     * Render function.
     *
     * Should echo the contents of the metabox.
     *
     * @param WP_Post|null $post
     *
     * @return void
     */
    public function renderMetaBox(?WP_Post $post): void;

}
