<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\DependencyInjection\Initializer;

use WRCE\Dependencies\Symfony\Component\DependencyInjection\Container;

/**
 * ServiceInitializer
 *
 * This class is responsible for initializing services that are tagged with the `force_initialize` tag.
 */
class ServiceInitializer
{

    private array $serviceIds = [];

    public function __construct(private Container $container)
    {
    }

    public function initializeServices()
    {
        foreach ($this->serviceIds as $id) {
            $this->container->get($id);
        }
    }

    public function addService(string $id): void
    {
        $this->serviceIds[] = $id;
    }

}