<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */ declare(strict_types=1);

namespace WRCE\Dependencies\Jawira\CaseConverter;

/**
 * Class CaseConverter
 *
 * Factory class which returns a Convert object.
 *
 * @author  Jawira Portugal <dev@tugal.be>
 */
class CaseConverter implements CaseConverterInterface
{
    /**
     * Returns a Convert object
     *
     * @param string $source Input string to be converted
     *
     * @return \WRCE\Dependencies\Jawira\CaseConverter\Convert
     * @throws \WRCE\Dependencies\Jawira\CaseConverter\CaseConverterException
     */
    public function convert(string $source): Convert
    {
        return new Convert($source);
    }
}
