<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Cache\Exception;

use function sprintf;

class CannotUpdateReadOnlyEntity extends CacheException
{
    public static function fromEntity(string $entityName): self
    {
        return new self(sprintf('Cannot update a readonly entity "%s"', $entityName));
    }
}
