<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\DBAL\SQL\Parser;

/**
 * SQL parser visitor
 *
 * @internal
 */
interface Visitor
{
    /**
     * Accepts an SQL fragment containing a positional parameter
     */
    public function acceptPositionalParameter(string $sql): void;

    /**
     * Accepts an SQL fragment containing a named parameter
     */
    public function acceptNamedParameter(string $sql): void;

    /**
     * Accepts other SQL fragments
     */
    public function acceptOther(string $sql): void;
}
