<?php

namespace RTMMailComposer\Model;

class EmailSection
{
    private string $id;
    private bool $enable = true;
    private string $title = '';
    private bool $showTitle = false;
    private string $text = '';
    private array $condition = [];
    private int $sortOrder = 0;

    public function __construct(string $id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getId(): string
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return EmailSection
     */
    public function setId(string $id): EmailSection
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return bool
     */
    public function isEnable(): bool
    {
        return $this->enable;
    }

    /**
     * @param bool $enable
     * @return EmailSection
     */
    public function setEnable(bool $enable): EmailSection
    {
        $this->enable = $enable;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return EmailSection
     */
    public function setTitle(string $title): EmailSection
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return bool
     */
    public function isShowTitle(): bool
    {
        return $this->showTitle;
    }

    /**
     * @param bool $showTitle
     * @return EmailSection
     */
    public function setShowTitle(?bool $showTitle): EmailSection
    {
        $this->showTitle = (bool)$showTitle;
        return $this;
    }

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @param string $text
     * @return EmailSection
     */
    public function setText(string $text): EmailSection
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return array
     */
    public function getCondition(): array
    {
        return $this->condition;
    }

    /**
     * @param array $condition
     * @return EmailSection
     */
    public function setCondition(array|bool $condition): EmailSection
    {
        $this->condition = $condition ?: [];
        return $this;
    }

    /**
     * @return int
     */
    public function getSortOrder(): int
    {
        return $this->sortOrder;
    }

    /**
     * @param int $sortOrder
     * @return EmailSection
     */
    public function setSortOrder(int $sortOrder): EmailSection
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }

    /**
     * @return bool
     */
    public function isBuiltIn(): bool
    {
        $hooks = array_keys(apply_filters('wrce_email_section_hooks', []));
        return in_array($this->id, $hooks);
    }

}
