<?php

use WRCE\Dependencies\Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;

return static function (ContainerConfigurator $configurator) {
    $services = $configurator->services();

    $services->load('RTMCustomMails\\Rest\\', __DIR__ . '/../src/Rest/')
        ->autowire()
        ->autoconfigure();

    $services->set(\RTMCustomMails\Email\EmailClassesService::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(\RTMCustomMails\Migrations::class)
        ->public()
        ->autoconfigure()
        ->autowire();
};
