<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Symfony\Bridge\Doctrine\Attribute;

use WRCE\Dependencies\Symfony\Bridge\Doctrine\ArgumentResolver\EntityValueResolver;
use WRCE\Dependencies\Symfony\Component\HttpKernel\Attribute\ValueResolver;

/**
 * Indicates that a controller argument should receive an Entity.
 */
#[\Attribute(\Attribute::TARGET_PARAMETER)]
class MapEntity extends ValueResolver
{
    public function __construct(
        public ?string $class = null,
        public ?string $objectManager = null,
        public ?string $expr = null,
        public ?array $mapping = null,
        public ?array $exclude = null,
        public ?bool $stripNull = null,
        public array|string|null $id = null,
        public ?bool $evictCache = null,
        bool $disabled = false,
        string $resolver = EntityValueResolver::class,
    ) {
        parent::__construct($resolver, $disabled);
    }

    public function withDefaults(self $defaults, ?string $class): static
    {
        $clone = clone $this;
        $clone->class ??= class_exists($class ?? '') ? $class : null;
        $clone->objectManager ??= $defaults->objectManager;
        $clone->expr ??= $defaults->expr;
        $clone->mapping ??= $defaults->mapping;
        $clone->exclude ??= $defaults->exclude ?? [];
        $clone->stripNull ??= $defaults->stripNull ?? false;
        $clone->id ??= $defaults->id;
        $clone->evictCache ??= $defaults->evictCache ?? false;

        return $clone;
    }
}
