<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use WRCE\Dependencies\Doctrine\DBAL\Types\Types;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Column;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Entity;
use WRCE\Dependencies\Doctrine\ORM\Mapping\GeneratedValue;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Id;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Index;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Table;

#[Entity]
#[Table(name: 'admin_note_actions')]
#[Index(name: 'note_id', columns: ['note_id'])]
class AdminNoteAction
{
    #[Id]
    #[GeneratedValue(strategy: 'IDENTITY')]
    #[Column(name: 'action_id', type: Types::BIGINT, options: ['unsigned' => true])]
    private int $id;

    #[Column(name: 'note_id', type: Types::BIGINT, nullable: false)]
    private int $noteId;

    #[Column(name: 'name', type: Types::STRING, length: 255, nullable: false)]
    private string $name;

    #[Column(name: 'label', type: Types::STRING, length: 255, nullable: false)]
    private string $label;

    #[Column(name: 'query', type: Types::TEXT, nullable: false)]
    private string $query;

    #[Column(name: 'status', type: Types::STRING, length: 255, nullable: false)]
    private string $status;

    #[Column(name: 'actioned_text', type: Types::STRING, length: 255, nullable: false)]
    private string $actionedText;

    #[Column(name: 'nonce_action', type: Types::STRING, length: 255, nullable: true)]
    private ?string $nonceAction;

    #[Column(name: 'nonce_name', type: Types::STRING, length: 255, nullable: true)]
    private ?string $nonceName;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return AdminNoteAction
     */
    public function setId(int $id): AdminNoteAction
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int
     */
    public function getNoteId(): int
    {
        return $this->noteId;
    }

    /**
     * @param int $noteId
     * @return AdminNoteAction
     */
    public function setNoteId(int $noteId): AdminNoteAction
    {
        $this->noteId = $noteId;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AdminNoteAction
     */
    public function setName(string $name): AdminNoteAction
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getLabel(): string
    {
        return $this->label;
    }

    /**
     * @param string $label
     * @return AdminNoteAction
     */
    public function setLabel(string $label): AdminNoteAction
    {
        $this->label = $label;
        return $this;
    }

    /**
     * @return string
     */
    public function getQuery(): string
    {
        return $this->query;
    }

    /**
     * @param string $query
     * @return AdminNoteAction
     */
    public function setQuery(string $query): AdminNoteAction
    {
        $this->query = $query;
        return $this;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return AdminNoteAction
     */
    public function setStatus(string $status): AdminNoteAction
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string
     */
    public function getActionedText(): string
    {
        return $this->actionedText;
    }

    /**
     * @param string $actionedText
     * @return AdminNoteAction
     */
    public function setActionedText(string $actionedText): AdminNoteAction
    {
        $this->actionedText = $actionedText;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getNonceAction(): ?string
    {
        return $this->nonceAction;
    }

    /**
     * @param string|null $nonceAction
     * @return AdminNoteAction
     */
    public function setNonceAction(?string $nonceAction): AdminNoteAction
    {
        $this->nonceAction = $nonceAction;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getNonceName(): ?string
    {
        return $this->nonceName;
    }

    /**
     * @param string|null $nonceName
     * @return AdminNoteAction
     */
    public function setNonceName(?string $nonceName): AdminNoteAction
    {
        $this->nonceName = $nonceName;
        return $this;
    }

}