<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\Entity;

use WRCE\Dependencies\Doctrine\ORM\Mapping as ORM;
use WRCE\Dependencies\Symfony\Component\Serializer\Attribute\Context;
use WRCE\Dependencies\Symfony\Component\Serializer\Attribute\Groups;

/**
 * WpCommentmeta
 */
#[
    ORM\Table('commentmeta'),
    ORM\Index(['meta_key'], name: 'meta_key'),
    ORM\Entity,
    ORM\Cache(usage: 'NONSTRICT_READ_WRITE', region: 'wp_commentmeta'),
]
class CommentMeta extends AbstractMeta
{

    #[
        ORM\ManyToOne(targetEntity: Comment::class, inversedBy: 'meta'),
        ORM\JoinColumn('comment_id', referencedColumnName: 'comment_ID')
    ]
    #[Groups(['read_meta_details', 'read_meta_comment'])]
    private Comment $comment;


    public function getComment(): Comment
    {
        return $this->comment;
    }

    public function setComment(Comment $comment): CommentMeta
    {
        $this->comment = $comment;
        return $this;
    }

    public static function getType(): string
    {
        return 'comment';
    }

}
