<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Query\AST;

use WRCE\Dependencies\Doctrine\Deprecations\Deprecation;

/**
 * InExpression ::= ArithmeticExpression ["NOT"] "IN" "(" (Literal {"," Literal}* | Subselect) ")"
 *
 * @deprecated Use {@see InListExpression} or {@see InSubselectExpression} instead.
 */
class InExpression extends Node
{
    /** @var bool */
    public $not;

    /** @var ArithmeticExpression */
    public $expression;

    /** @var mixed[] */
    public $literals = [];

    /** @var Subselect|null */
    public $subselect;

    /** @param ArithmeticExpression $expression */
    public function __construct($expression)
    {
        if (! $this instanceof InListExpression && ! $this instanceof InSubselectExpression) {
            Deprecation::trigger(
                'doctrine/orm',
                'https://github.com/doctrine/orm/pull/10267',
                '%s is deprecated, use %s or %s instead.',
                self::class,
                InListExpression::class,
                InSubselectExpression::class
            );
        }

        $this->expression = $expression;
    }

    /**
     * {@inheritDoc}
     */
    public function dispatch($sqlWalker)
    {
        // We still call the deprecated method in order to not break existing custom SQL walkers.
        return $sqlWalker->walkInExpression($this);
    }
}
