<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Mapping;

use Attribute;
use WRCE\Dependencies\Doctrine\Common\Annotations\Annotation\NamedArgumentConstructor;

/**
 * @Annotation
 * @NamedArgumentConstructor()
 * @Target("PROPERTY")
 */
#[Attribute(Attribute::TARGET_PROPERTY)]
final class Embedded implements MappingAttribute
{
    /**
     * @var string|null
     * @readonly
     */
    public $class;

    /**
     * @var string|bool|null
     * @readonly
     */
    public $columnPrefix;

    public function __construct(?string $class = null, $columnPrefix = null)
    {
        $this->class        = $class;
        $this->columnPrefix = $columnPrefix;
    }
}
