<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Mapping\Driver;

use WRCE\Dependencies\Doctrine\Persistence\Mapping\Driver\AnnotationDriver as PersistenceAnnotationDriver;
use WRCE\Dependencies\Doctrine\Persistence\Mapping\Driver\MappingDriver;

use function class_exists;

if (! class_exists(PersistenceAnnotationDriver::class)) {
    /** @internal This class will be removed in ORM 3.0. */
    abstract class CompatibilityAnnotationDriver implements MappingDriver
    {
    }
} else {
    /** @internal This class will be removed in ORM 3.0. */
    abstract class CompatibilityAnnotationDriver extends PersistenceAnnotationDriver
    {
    }
}
