<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Exception;

use WRCE\Dependencies\Doctrine\ORM\Cache\Exception\CacheException;

use function sprintf;

final class UnexpectedAssociationValue extends CacheException
{
    public static function create(
        string $class,
        string $association,
        string $given,
        string $expected
    ): self {
        return new self(sprintf(
            'Found entity of type %s on association %s#%s, but expecting %s',
            $given,
            $class,
            $association,
            $expected
        ));
    }
}
