<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\Repository;

use WRCE\Dependencies\Doctrine\ORM\EntityManagerInterface;
use WRCE\Dependencies\Doctrine\ORM\EntityRepository;
use WRCE\Dependencies\Doctrine\ORM\Repository\RepositoryFactory;
use WRCE\Dependencies\Doctrine\Persistence\ObjectRepository;
use ReflectionMethod;

if ((new ReflectionMethod(RepositoryFactory::class, 'getRepository'))->hasReturnType()) {
    // ORM >= 3
    /** @internal */
    trait RepositoryFactoryCompatibility
    {
        /**
         * Gets the repository for an entity class.
         *
         * @param class-string<T> $entityName
         *
         * @return EntityRepository<T>
         *
         * @template T of object
         */
        public function getRepository(EntityManagerInterface $entityManager, string $entityName): EntityRepository
        {
            return $this->doGetRepository($entityManager, $entityName, true);
        }
    }
} else {
    // ORM 2
    /** @internal */
    trait RepositoryFactoryCompatibility
    {
        /** {@inheritDoc} */
        public function getRepository(EntityManagerInterface $entityManager, $entityName): ObjectRepository
        {
            return $this->doGetRepository($entityManager, $entityName, false);
        }
    }
}
