<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\Middleware;

use WRCE\Dependencies\Doctrine\DBAL\Driver as DriverInterface;
use WRCE\Dependencies\Doctrine\DBAL\Driver\Middleware;
use WRCE\Dependencies\Symfony\Bridge\Doctrine\Middleware\Debug\DebugDataHolder;
use WRCE\Dependencies\Symfony\Bridge\Doctrine\Middleware\Debug\Driver;
use Symfony\Component\Stopwatch\Stopwatch;

class DebugMiddleware implements Middleware, ConnectionNameAwareInterface
{
    private DebugDataHolder $debugDataHolder;
    private ?Stopwatch $stopwatch;
    private string $connectionName = 'default';

    public function __construct(DebugDataHolder $debugDataHolder, ?Stopwatch $stopwatch)
    {
        $this->debugDataHolder = $debugDataHolder;
        $this->stopwatch       = $stopwatch;
    }

    public function setConnectionName(string $name): void
    {
        $this->connectionName = $name;
    }

    public function wrap(DriverInterface $driver): DriverInterface
    {
        /** @psalm-suppress InternalClass,InternalMethod */
        return new Driver($driver, $this->debugDataHolder, $this->stopwatch, $this->connectionName);
    }
}
