<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 17-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\DBAL\Query;

final class Limit
{
    private ?int $maxResults;
    private int $firstResult;

    public function __construct(?int $maxResults, int $firstResult)
    {
        $this->maxResults  = $maxResults;
        $this->firstResult = $firstResult;
    }

    public function isDefined(): bool
    {
        return $this->maxResults !== null || $this->firstResult !== 0;
    }

    public function getMaxResults(): ?int
    {
        return $this->maxResults;
    }

    public function getFirstResult(): int
    {
        return $this->firstResult;
    }
}
