<?php

namespace RTMCustomMails;

use WRCE\Dependencies\Doctrine\ORM\EntityManagerInterface;
use RTMCustomMails\Database\Entity\Email;
use WRCE\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Action;
use WRCE\Dependencies\WordpressModels\DependencyInjection\Initializer\Attributes\ForceInitialize;

#[ForceInitialize]
class Migrations
{

    private \wpdb $wpdb;

    private const DB_VERSION = '0.4.0';

    public function __construct(private EntityManagerInterface $entityManager)
    {
        global $wpdb;
        $this->wpdb = $wpdb;

        if (get_option('wrce_db_version') !== self::DB_VERSION) {
            add_action('init', $this->runMigrations(...));
        }
    }

    public function isFullyMigrated()
    {
        return get_option('wrce_db_version') === self::DB_VERSION;
    }

    public function runMigrations()
    {
        do_action('wrce_migrations');
    }

    /**
     * Check whether the wrce_email table exists, if not run the create table command
     *
     * @return void
     */
    #[Action('wrce_migrations', priority: 0)]
    public function initialMigration()
    {
        $versionAfterMigration = '0.4.0';
        $tableName = $this->entityManager->getClassMetadata(Email::class)->getTableName();
        if (version_compare(get_option('wrce_db_version', '0.0.0'), $versionAfterMigration, '<')) {
            $this->wpdb->query("CREATE TABLE $tableName (
    id VARCHAR(255) NOT NULL, 
    recipient_type VARCHAR(255) NOT NULL, 
    object_type VARCHAR(255) NOT NULL, 
    title VARCHAR(255) NOT NULL, 
    description LONGTEXT DEFAULT NULL, 
    heading VARCHAR(255) NOT NULL, 
    subject VARCHAR(255) NOT NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME DEFAULT NULL,
    deleted_at DATETIME DEFAULT NULL, 
    PRIMARY KEY(id));");
            update_option('wrce_db_version', $versionAfterMigration);
        }
    }



}