<?php

namespace RTMCustomMails\EmailSections;

use WRCE\Dependencies\Timber\Timber;
use WRCE\Dependencies\WordpressModels\Traits\SingletonTrait;

/**
 *
 */
class EmailSections
{
    use SingletonTrait;

    private function __construct()
    {
        Timber::$twig_cache = WP_DEBUG;

        add_filter('timber/locations', [$this, 'addTimberTemplateLocations']);
        add_filter('timber/cache/location', [$this, 'setTimberCacheLocation']);

        SectionValidation::instance();
    }

    public static function getSectionPresets()
    {
        return apply_filters('wrce_email_section_presets', get_option('wrce_email_section_presets', []));
    }

    /**
     * @param string $location
     * @return string
     */
    public function setTimberCacheLocation(string $location): string
    {
        return WP_DEBUG ? (WRCE_ROOT_PATH . 'cache/') : $location;
    }

    /**
     * @param string[] $locations
     * @return string[]
     */
    public function addTimberTemplateLocations(array $locations = []): array
    {
        $locations[] = WRCE_ROOT_PATH . 'templates/emails/';

        return $locations;
    }

}